﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace S04_Projet
{
    class Menu
    {
        private string[] menuItems;

        public Menu(string[] menuItems)
        {
            this.menuItems = menuItems;
        }

        public int ShowMenu(int xOffset, int yOffset)
        {
            int choosenItem = 0;

            Console.SetCursorPosition(xOffset, yOffset);
            for (int i = 0; i < menuItems.Length; i++)
            {
                Console.WriteLine(((choosenItem == i) ? ">> " : "   ") + menuItems[i]);
            }


            ConsoleKeyInfo key;

            do
            {
                key = Console.ReadKey();
                Console.SetCursorPosition(xOffset, yOffset + choosenItem);
                Console.Write("  ");
                if (key.Key == ConsoleKey.DownArrow)
                {
                    choosenItem++;
                    if (choosenItem == menuItems.Length) choosenItem = 0;
                }
                else if (key.Key == ConsoleKey.UpArrow)
                {
                    choosenItem--;
                    if (choosenItem == -1) choosenItem = menuItems.Length - 1;
                }
                Console.SetCursorPosition(xOffset, yOffset + choosenItem);
                Console.Write(">>");
            } while (key.Key != ConsoleKey.Escape && key.Key != ConsoleKey.Enter);

            if (key.Key == ConsoleKey.Escape) Environment.Exit(0);

            return choosenItem;
        }
    }
}
