﻿using System;
using System.Diagnostics;
using System.IO;

namespace S04_Projet
{
    class Program
    {
        //public static bool MULTITHREADING_LOAD = false;
        public static bool MULTITHREADING = false;
        public static bool DEBUG = false;

        private static string[] menuItems = new string[] { "Charger une image", "Créer une image" };

        private static Menu welcomeMenu = new Menu(menuItems);
        private static MyImage img;

        private static Stopwatch sw = new Stopwatch();

        static void Main(string[] args)
        {
            #region Arguments
            if (args.Length > 0)
            {
                Arguments(args, 0);
            }
            #endregion

            #region Display
            else
            {
                Console.ForegroundColor = ConsoleColor.White;
                Console.WriteLine("#############################################################");
                Console.WriteLine("###                       Bienvenue                       ###");
                Console.WriteLine("#############################################################");
                Console.WriteLine();

                int choice = welcomeMenu.ShowMenu(0, 5); // 0 pour charger une image, 1 pour la créer
                if (choice == 0)
                {
                    Console.Clear();
                    img = Display.LoadImage();
                }
                else
                {
                    Console.Clear();
                    img = Display.CreateImageOperation();
                    Display.fileInfos = img.ToString();
                }

                Display.Operation ToDo = Display.AskForOperation();
                MyImage newImg = Display.PerformOperation(ToDo, img);

                while (newImg != null)
                {
                    ToDo = Display.AskForOperation();
                    newImg = Display.PerformOperation(ToDo, newImg);
                }

                Console.ForegroundColor = ConsoleColor.Green;
                Console.WriteLine("Image sauvegardée en {0}ms!", Display.elapsedTime);
                Console.Read();
            }
            #endregion            
        }

        private static void Arguments(string[] args, int i)
        {
            int increment = 1;
            if (DEBUG) sw.Restart();

            if (args[i] == "--input" || args[i] == "-i")
            {
                img = new MyImage(args[i + 1]);
                increment = 2;
            }
            else if (args[i] == "--output" || args[i] == "-o")
            {
                if (img != null) img.Save(args[i + 1]);
                increment = 2;
            }
            else if (args[i] == "--debug" || args[i] == "-d")
                DEBUG = true;
            else if (args[i] == "--multithreading" || args[i] == "-MT")
                MULTITHREADING = true;
            else if (args[i] == "--filter" || args[i] == "-f")
            {
                increment = 2;
                int choix = 0;
                switch(args[i+1].ToLower())
                {
                    case "flou":
                    case "blur":
                        choix = 1;
                        break;
                    case "edgedetection":
                    case "detectionbord":
                        choix = 3;
                        break;
                    case "renforcement":
                    case "reinforcement":
                        choix = 2;
                        break;
                    case "repoussage":
                    case "spinning":
                        choix = 4;
                        break;
                    case "constraste":
                    case "constrast":
                        choix = 0;
                        break;
                }
                img = img.Filter(Filter.Filtres[choix], Filter.Facteurs[choix]);
            };

            if (DEBUG)
            {
                sw.Stop();
                File.AppendAllText("debug.csv", args[i].Replace("-","") + ";" + sw.ElapsedMilliseconds + ";\n");
            }
            if (i + increment < args.Length) Arguments(args, i + increment);
        }
    }
}
