﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace S04_Projet
{
    public class Pixel
    {
        byte r;
        byte g;
        byte b;

        public Pixel(byte r, byte g, byte b)
        {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Pixel(byte[] rgb)
        {
            r = rgb[0];
            g = rgb[1];
            b = rgb[2];
        }

        public byte[] getRGB()
        {
            return new byte[] { r, g, b };
        }

        public Pixel getGrayScale(byte scale)
        {
            byte pix = (byte)((r + g + b) / 3);
            pix = (byte)((pix / 255) * (scale-1)); // [0, scale-1]
            if (pix == 1) Console.WriteLine("1");
            pix = (byte)(pix * 255 * (scale-1));
            if (pix == 255) Console.WriteLine("255");
            return new Pixel(pix, pix, pix);
        }

        public Pixel getGrayScaleLuminosity(byte scale)
        {
            byte pix = (byte)(0.21 * r + 0.72 * g + 0.07 * b);
            pix = (byte)(pix / (255 / scale));
            pix = (byte)((pix * (255 / scale)) + (255 / scale));
            return new Pixel(pix, pix, pix);
        }
    }
}
