﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using S04_Projet;

namespace Tests
{
    [TestClass]
    public class FilterTest
    {
        [TestMethod]
        public void contrastPlus()
        {
            short[,] contrastPlus = new short[,]
            {
                { 0,-1, 0 },
                {-1, 5,-1 },
                { 0,-1, 0 }
            };
            CollectionAssert.AreEqual(contrastPlus, Filter.Filtres[0]);
        }

        [TestMethod]
        public void flou()
        {
            short[,] flou = new short[,]
            {
                { 1, 1, 1 },
                { 1, 1, 1 },
                { 1, 1, 1 }
            };
            CollectionAssert.AreEqual(flou, Filter.Filtres[1]);
        }

        [TestMethod]
        public void renforcement()
        {
            short[,] renforcement = new short[,]
            {
                { 0, 0, 0 },
                {-1, 1, 0 },
                { 0, 0, 0 }
            };
            CollectionAssert.AreEqual(renforcement, Filter.Filtres[2]);
        }

        [TestMethod]
        public void detection()
        {
            short[,] detection = new short[,]
            {
                { 0, 1, 0 },
                { 1,-4, 1 },
                { 0, 1, 0 }
            };
            CollectionAssert.AreEqual(detection, Filter.Filtres[3]);
        }

        [TestMethod]
        public void repoussage()
        {
            short[,] repoussage = new short[,]
            {
                {-2,-1, 0 },
                {-1, 1, 1 },
                { 0, 1, 2 }
            };
            CollectionAssert.AreEqual(repoussage, Filter.Filtres[4]);
        }
    }
}
