﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Diagnostics;
using System.IO;

namespace S04_Projet
{
    class Program
    {
        public static bool MULTITHREADING_LOAD = false;
        public static bool MULTITHREADING = true;
        static void Main(string[] args)
        {
            #region Filters Matrix
            short[,] boxBlurFilter = new short[,] {
                {1,1,1 },
                {1,1,1 },
                {1,1,1 }
            };

            short[,] identityFilter = new short[,]
            {
                { 0, 0, 0 },
                { 0, 1, 0 },
                { 0, 0, 0 }
            };

            short[,] edgeDetect1Filter = new short[,]
            {
                { 1, 0, -1 },
                { 0, 0, 0  },
                { -1, 0, 1 }
            };

            short[,] edgeDetect2Filter = new short[,]
            {
                { 0, 1, 0 },
                { 1, -4, 1 },
                { 0, 1, 0 }
            };

            short[,] edgeDetect3Filter = new short[,]
            {
                { -1, -1, -1 },
                { -1, 8, -1 },
                { -1, -1, -1 }
            };

            short[,] sharpenFilter = new short[,]
            {
                { 0, -1, 0 },
                { -1, 5, -1 },
                { 0, -1, 0 }
            };
            #endregion

            Stopwatch sw = new Stopwatch();

            MyImage imgg = new MyImage("img/image.bmp");
            Console.WriteLine("Loading done");
            sw.Start();
            MyImage newImg = imgg.Filter(sharpenFilter, 1);
            sw.Stop();
            newImg.Save("filter.bmp");
            Console.WriteLine(sw.ElapsedMilliseconds);
            Console.Read();
            
            /*
            #region Arguments
            if (args.Length > 0)
            {
                MULTITHREADING = false;
                bool filter = false;
                string inputPath = "";
                string outputPath = "";
                for (int i = 0; i < args.Length; i++)
                {
                    if (args[i].Equals("--input"))
                    {
                        inputPath = args[i + 1];
                        i++;
                    }
                    else if (args[i].Equals("--output"))
                    {
                        outputPath = args[i + 1];
                        i++;
                    }
                    else if (args[i].Equals("--multithreading")) MULTITHREADING = true;
                    else if (args[i].Equals("--filter")) filter = true;
                }
                if(inputPath != "")
                {
                    MyImage img = new MyImage(inputPath);
                    if (filter) img = img.ApplyConvFilter(edgeDetect1Filter, 1);
                    if (outputPath != "")
                    {
                        img.Save(outputPath);
                    } else
                    {
                        Console.WriteLine("No output specified, program will only load image in memory and stop");
                    }


                } else
                {
                    Console.WriteLine("--input argument required");
                }
            }
            #endregion

            #region Display
            else
            {
                Console.ForegroundColor = ConsoleColor.White;
                Console.WriteLine("#############################################################");
                Console.WriteLine("###                       Bienvenue                       ###");
                Console.WriteLine("#############################################################");
                Console.WriteLine();

                MyImage img = Display.LoadImage();
                Display.Operation ToDo = Display.AskForOperation();
                MyImage newImg = Display.PerformOperation(ToDo, img);

                while (newImg != null)
                {
                    ToDo = Display.AskForOperation();
                    newImg = Display.PerformOperation(ToDo, newImg);
                }

                Console.ForegroundColor = ConsoleColor.Green;
                Console.WriteLine("Image sauvegardée en {0}ms!", Display.elapsedTime);

                Console.Read();
            }
            #endregion
            */
        }
    }
}
