﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Diagnostics;
using System.IO;

namespace S04_Projet
{
    class Program
    {
        static void Main(string[] args)
        {
            //MyImage img = new MyImage("img/coco.bmp");
            Console.WriteLine("#############################################################");
            Console.WriteLine("###                       Bienvenue                       ###");
            Console.WriteLine("#############################################################");
            Console.WriteLine();

            string path;
            bool validPath = false;
            byte[] file = new byte[0];

            do
            {
                Console.WriteLine("Veuillez saisir le nom du fichier à traiter :");
                path = Console.ReadLine();
                try
                {
                    file = File.ReadAllBytes(path);
                }
                catch (Exception e)
                {
                    Console.ForegroundColor = ConsoleColor.Red;
                    Console.WriteLine("Une erreur est survenue : " + e.Message);
                    Console.ForegroundColor = ConsoleColor.White;
                }
                if (file.Length != 0) validPath = true;
            } while (!validPath);

            Console.Clear();

            MyImageThread myImageThread = new MyImageThread(file);
            Thread imageThread = new Thread(new ThreadStart(myImageThread.ThreadLoop));

            imageThread.Start();

            while(imageThread.IsAlive)
            {
                Console.Write("Traitement en cours de l'image.");
                Thread.Sleep(250);
                Console.Write(".");
                Thread.Sleep(250);
                Console.Write(".");
                Thread.Sleep(250);
                Console.Clear();
            }

            Console.WriteLine("Image chargée en {0}ms\n", myImageThread.loadTime);
            Console.WriteLine(myImageThread.image.toString());
            //Console.Clear();
            Console.Read();




            #region Test
            /*MyImage imgRotate90 = img.Rotate90();
            imgRotate90.Save("90.bmp");
            MyImage imgRotate180 = img.Rotate180();
            imgRotate180.Save("180.bmp");
            MyImage imgRotate270 = img.Rotate270();
            imgRotate270.Save("270.bmp");
            Console.WriteLine("Rotations terminées");

            MyImage bwLumnisity = img.ToGrayScale(2, MyImage.grayFilterType.LUMINOSITY);
            bwLumnisity.Save("bwLumnosity.bmp");
            MyImage bwLinear = img.ToGrayScale(2, MyImage.grayFilterType.LINEAR);
            bwLinear.Save("bwLinear.bmp");
            Console.WriteLine("Done");*/

            /*int[,] convFilter = new int[,]
            {
                { 0, 0, 0 },
                { 0, 0, 7 },
                { 3, 5, 1 }
            };
            MyImage conv = img.ApplyConvFilter(convFilter, (1.0 / 16.0));
            conv.Save("dither.bmp");
            Console.WriteLine("Done");*/
            #endregion
        }
    }
}
