﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace S04_Projet
{
    public class Pixel
    {
        public byte r { get; private set; }
        public byte g { get; private set; }
        public byte b { get; private set; }

        public Pixel(byte r, byte g, byte b)
        {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Pixel(byte unifiedColors)
        {
            r = unifiedColors;
            g = unifiedColors;
            b = unifiedColors;
        }

        public Pixel(byte[] rgb)
        {
            r = rgb[0];
            g = rgb[1];
            b = rgb[2];
        }

        public byte[] getRGB()
        {
            return new byte[] { r, g, b };
        }

        public Pixel getGrayScale(byte scale)
        {
            byte total = (byte)((r + g + b) / 3);
            total = (byte)(Math.Round((double)total / (255/(scale-1))) * (255 / (scale - 1)));
            return new Pixel(total);
        }

        public Pixel getGrayScaleLuminosity(byte scale)
        {
            byte total = (byte)(0.21 * r + 0.72 * g + 0.07 * b);
            total = (byte)(Math.Round((double)total / (255 / (scale - 1))) * (255 / (scale - 1)));
            return new Pixel(total);
        }

        public void SetR(byte r) { this.r = r; }
        public void SetG(byte g) { this.g = g; }
        public void SetB(byte b) { this.b = b; }
    }
}
