﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Diagnostics;
using System.IO;

namespace S04_Projet
{
    class Program
    {
        static void Main(string[] args)
        {
            byte[] file = File.ReadAllBytes("img/lac_en_montagne.bmp");

            #region Header
            string format = (char)file[0] + "" + (char)file[1];
            int endian = MyImage.EndianToInt(file, 2, 6);
            int offset = MyImage.EndianToInt(file, 10, 14);
            Console.WriteLine("Format : {0}\nTaille : {1} octets", format, endian);
            Console.WriteLine("Offset : " + offset);
            #endregion

            #region File info
            int fileInfoHeaderSize = MyImage.EndianToInt(file, 14, 18);
            int width = MyImage.EndianToInt(file, 18, 22);
            int height = MyImage.EndianToInt(file, 22, 26);
            int colorPlanesNb = MyImage.EndianToInt(file, 26, 28);
            int bitsPerPixel = MyImage.EndianToInt(file, 28, 30);
            int compressionMethod = MyImage.EndianToInt(file, 30, 34);
            int imgSize = MyImage.EndianToInt(file, 34, 38);
            int horizontalRes = MyImage.EndianToInt(file, 38, 42);
            int VerticalRes = MyImage.EndianToInt(file, 42, 46);
            int nbColor = MyImage.EndianToInt(file, 46, 50);
            int nbImportantColor = MyImage.EndianToInt(file, 50, 54);

            Console.WriteLine("File info header size : {0} octets", fileInfoHeaderSize);
            Console.WriteLine("Size : {0}x{1}px",width, height);
            Console.WriteLine("Color planes number : " + colorPlanesNb);
            Console.WriteLine("Bits per pixel : " + bitsPerPixel);
            Console.WriteLine("Compression method : " + compressionMethod);
            Console.WriteLine("Image size : {0} octets", imgSize);
            Console.WriteLine("Horizontal res : {0}\nVertical res : {1}", horizontalRes, VerticalRes);
            Console.WriteLine("Number of colors : " + nbColor);
            Console.WriteLine("Number of important colors : " + nbImportantColor);
            #endregion

            /*for (int i = 54; i < file.Length; i++)
            {
                Console.Write(file[i] + "\t");
            }*/
            Console.Read();
        }
    }
}
