﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Diagnostics;
using System.IO;

namespace S04_Projet
{
    class Program
    {
        public static bool MULTITHREADING = false;
        static void Main(string[] args)
        {
            #region Filters Matrix
            short[,] boxBlurFilter = new short[,] {
                {1,1,1 },
                {1,1,1 },
                {1,1,1 }
            };

            short[,] identityFilter = new short[,]
            {
                { 0, 0, 0 },
                { 0, 1, 0 },
                { 0, 0, 0 }
            };

            short[,] edgeDetect1Filter = new short[,]
            {
                { 1, 0, -1 },
                { 0, 0, 0  },
                { -1, 0, 1 }
            };

            short[,] edgeDetect2Filter = new short[,]
            {
                { 0, 1, 0 },
                { 1, -4, 1 },
                { 0, 1, 0 }
            };

            short[,] edgeDetect3Filter = new short[,]
            {
                { -1, -1, -1 },
                { -1, 8, -1 },
                { -1, -1, -1 }
            };

            short[,] sharpenFilter = new short[,]
            {
                { 0, -1, 0 },
                { -1, 5, -1 },
                { 0, -1, 0 }
            };
            #endregion
            
            Console.ForegroundColor = ConsoleColor.White;
            Console.WriteLine("#############################################################");
            Console.WriteLine("###                       Bienvenue                       ###");
            Console.WriteLine("#############################################################");
            Console.WriteLine();

            MyImage img = Display.LoadImage();
            Display.Operation ToDo = Display.AskForOperation();
            MyImage newImg = Display.PerformOperation(ToDo, img);

            while (newImg != null)
            {
                ToDo = Display.AskForOperation();
                newImg = Display.PerformOperation(ToDo, newImg);
            }

            Console.ForegroundColor = ConsoleColor.Green;
            Console.WriteLine("Image sauvegardée en {0}ms!", Display.elapsedTime);

            Console.Read();
        }
    }
}
