﻿using System;
using System.IO;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace S04_Projet
{
    public class MyImage
    {
        private string type;
        private int fileSize;
        private int offset;
        private int width;
        private int height;
        private Pixel[,] Pixels;

        public MyImage(string path)
        {
            byte[] file = new byte[0];
            try
            {
                file = File.ReadAllBytes(path);
            }
            catch (Exception e)
            {
                Console.WriteLine("Une erreur est survenue : " + e.Message);
            }
            finally
            {
                #region Header
                string format = (char)file[0] + "" + (char)file[1];
                int endian = EndianToInt(file, 2, 6);
                int offset = EndianToInt(file, 10, 14);
                Console.WriteLine("Format : {0}\nTaille : {1} octets", format, endian);
                Console.WriteLine("Offset : " + offset);
                #endregion

                #region File info
                int fileInfoHeaderSize = EndianToInt(file, 14, 18);
                int width = EndianToInt(file, 18, 22);
                int height = EndianToInt(file, 22, 26);
                int colorPlanesNb = EndianToInt(file, 26, 28);
                int bitsPerPixel = EndianToInt(file, 28, 30);
                int compressionMethod = EndianToInt(file, 30, 34);
                int imgSize = EndianToInt(file, 34, 38);
                int horizontalRes = EndianToInt(file, 38, 42);
                int VerticalRes = EndianToInt(file, 42, 46);
                int nbColor = EndianToInt(file, 46, 50);
                int nbImportantColor = EndianToInt(file, 50, 54);

                Console.WriteLine("File info header size : {0} octets", fileInfoHeaderSize);
                Console.WriteLine("Size : {0}x{1}px", width, height);
                Console.WriteLine("Color planes number : " + colorPlanesNb);
                Console.WriteLine("Bits per pixel : " + bitsPerPixel);
                Console.WriteLine("Compression method : " + compressionMethod);
                Console.WriteLine("Image size : {0} octets", imgSize);
                Console.WriteLine("Horizontal res : {0}\nVertical res : {1}", horizontalRes, VerticalRes);
                Console.WriteLine("Number of colors : " + nbColor);
                Console.WriteLine("Number of important colors : " + nbImportantColor);
                #endregion
                
                #region Pixel array
                int pixelNumber = width * height;
                Pixels = new Pixel[width, height];

                Stopwatch s = new Stopwatch();

                #region Mono
                s.Start();
                for (int i = 0; i < pixelNumber; i++)
                {
                    int x = i % width;
                    int y = i / width;
                    byte r = file[i * 3 + offset];
                    byte g = file[i * 3 + offset + 1];
                    byte b = file[i * 3 + offset + 2];
                    Pixels[x, y] = new Pixel(r,g,b);
                }
                s.Stop();
                Console.WriteLine(s.ElapsedMilliseconds);
                #endregion

                #region Parallel 
                /*s.Start();
                Parallel.For(0, pixelNumber, i =>
                {
                    int x = i % width;
                    int y = i / width;
                    Pixels[x, y] = new Pixel(file[i * 3 + offset], file[i * 3 + offset + 1], file[i * 3 + offset + 2]);
                });
                s.Stop();
                Console.WriteLine(s.ElapsedMilliseconds);*/
                
                #endregion

                #endregion
            }
        }

        public void FromImageToFile(string path)
        {

        }
        
        public static int EndianToInt(byte[] arr, int from, int to)
        {
            int somme = 0;
            for (int i = from; i < to; i++) somme += (arr[i] << ((i-from) * 8));
            return somme;
        }
        /*
        public byte[] IntToEndian(int val)
        {

        }*/
    }
}
