﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using S04_Projet;

namespace ImageProcessing_Test
{
    [TestClass]
    public class Pixel_Test
    {
        [TestMethod]
        public void Pixel_RGB_Separate()
        {
            Pixel pixel = new Pixel(0, 127, 255);
            Assert.AreEqual(0, pixel.r);
            Assert.AreEqual(127, pixel.g);
            Assert.AreEqual(255, pixel.b);
        }

        [TestMethod]
        public void Pixel_RGB_Unified()
        {
            Pixel pixel = new Pixel(0);
            Assert.AreEqual(0, pixel.r);
            Assert.AreEqual(0, pixel.g);
            Assert.AreEqual(0, pixel.b);
        }

        [TestMethod]
        public void Pixel_RGB_Array()
        {
            Pixel pixel = new Pixel(new byte[] { 0, 127, 255 });
            Assert.AreEqual(0, pixel.r);
            Assert.AreEqual(127, pixel.g);
            Assert.AreEqual(255, pixel.b);
        }

        [TestMethod]
        public void Pixel_getRGB()
        {
            byte[] rgb = new byte[] { 0, 127, 255 };
            Pixel pixel = new Pixel(rgb);
            CollectionAssert.AreEqual(rgb, pixel.getRGB());
        }

        [TestMethod]
        public void Pixel_getBGR()
        {
            Pixel pixel = new Pixel(0,127,255);
            CollectionAssert.AreEqual(new byte[] { 255, 127, 0 }, pixel.getBGR());
        }
    }
}
