﻿using System.Diagnostics;
using System.IO;

namespace ImageProcessing_Benchmark
{
    class Program
    {
        static void Main(string[] args)
        {
            string results = "";
            Stopwatch sw = new Stopwatch();
            System.Console.WriteLine("Benchmarking");

            for (int i = 0; i < 10; i++)
            {
                sw.Restart();
                ProcessStartInfo processStartInfo = new ProcessStartInfo();
                processStartInfo.Arguments = "--input flocon.bmp --multithreading";
                processStartInfo.FileName = "S04_Projet.exe";
                Process.Start(processStartInfo);
                while (Process.GetProcessesByName("S04_Projet").Length != 0) System.Threading.Thread.Sleep(20);
                sw.Stop();
                results += sw.ElapsedMilliseconds + "\n";
            }

            File.WriteAllText("bench.csv", results);
            System.Console.WriteLine("Done");
        }
    }
}
