﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Text.RegularExpressions;
using System.Drawing;

namespace PDF_fill
{
    public class Program
    {
        public static List<Personne> Personnes = new List<Personne>();

        public static void Main(string[] args)
        {
            //Personnes = ChargerPersonnes();

            Bitmap doc = new Bitmap("demande.bmp");
            RectangleF nomLocation = new RectangleF(200, 1055, 1050,100);
            RectangleF prenomLocation = new RectangleF(1500, 1055, 800,100);
            RectangleF SSLocation = new RectangleF(1545, 1145, 700,100);

            using (Graphics g = Graphics.FromImage(doc))
            {
                using (Font arialFont = new Font("Arial", 10))
                {
                    g.DrawString("Test 1aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa23", arialFont, Brushes.Blue, nomLocation);
                    g.DrawString("Test 456", arialFont, Brushes.Blue, prenomLocation);
                }
                using (Font arialFont = new Font("Arial", 18))
                {
                    g.DrawString("2.87.03.84.007.197", arialFont, Brushes.Blue, SSLocation);
                }
            }

            doc.Save("test.bmp");

            foreach (Personne p in Personnes)
            {
                Console.WriteLine("{0} - {1} : {2}", p.Nom, p.Prenom, p.NumSecu);
            }

            Console.Read();
        }

        public static List<Personne> ChargerPersonnes()
        {
            string[] entrees = File.ReadAllLines("data.csv");
            List<Personne> Personnes = new List<Personne>();
            Personne _p;
            string[] infos;

            foreach (string entree in entrees)
            {
                infos = entree.Split(';');

                _p = new Personne();
                _p.Nom = infos[0];
                _p.Prenom = infos[1];
                _p.DateNaissance = DateTime.FromOADate(int.Parse(infos[7])).ToShortDateString();
                _p.LieuNaissance = infos[8];
                _p.CPNaissance = infos[9];
                _p.NumSecu = infos[10];
                _p.Profession = infos[16];

                Regex rgxAdresse = new Regex(@"-\s+(\d){5}.*");
                Regex rgxCP = new Regex(@"(\d){5}");
                Regex rgxVille = new Regex(@".*(\d){5}\s+");
                _p.Adresse = rgxAdresse.Replace(infos[11], "");
                _p.CP = rgxCP.Match(infos[11]).Groups[0].ToString();
                _p.Ville = rgxVille.Replace(infos[11], "");

                Personnes.Add(_p);
            }

            return Personnes;
        }
    }
}
