/*global google */

import React, { useState } from 'react';
import { saveAs } from "file-saver";
import './App.css';

import { makeStyles } from '@material-ui/core/styles';
import Paper from "@material-ui/core/Paper";
import TextField from "@material-ui/core/TextField";
import Divider from "@material-ui/core/Divider";
import Grid from "@material-ui/core/Grid";
import AppBar from "@material-ui/core/AppBar";
import Toolbar from '@material-ui/core/Toolbar';
import Typography from '@material-ui/core/Typography';
import Button from "@material-ui/core/Button";

import Section from "./Section";

const useStyles = makeStyles(theme => ({
	root: {
		flexGrow: 1
	},
	paper: {
		padding: theme.spacing(2, 3)
	},
	menuButton: {
		marginRight: theme.spacing(2),
	},
	title: {
		flexGrow: 1,
	},
	margin: {
		marginTop: theme.spacing(3),
	},
	button: {
		margin: theme.spacing(1),
	},
}));

function App() {
	const classes = useStyles();

	const [state, setState] = useState({
		sections: [],
		name: ""
	}
	);

	const save = () => {
		let name = prompt("Nom du fichier");
		let blob = new Blob([JSON.stringify(state)], { type: "application/json" });
		saveAs(blob, name + ".json");
	}

	const generate = () => {

	}

	const loadConfig = () => {
		let config;
		try {
			config = JSON.parse(state.config)
		} catch (e) {
			alert("Impossible de charger cette configuration")
			console.error(e);
			return;
		}
		setState({ ...config })
	}

	const addSection = () => {
		setState({ ...state, sections: [...state.sections, { name: "Nouvelle section", categories: [] }] });
	}

	const deleteSection = i => () => {
		if (window.confirm("Êtes vous sûr de vouloir supprimer cette section ?"))
			setState({ sections: state.sections.filter((s, ind) => ind !== i) })
	}

	const setSection = i => update => {
		let sections = Object.assign(state.sections);
		sections[i] = update;
		setState({
			...state,
			sections: sections
		});
	}

	const handleChange = e => {
		setState({ ...state, [e.target.name]: e.target.value });
	}

	return (
			<Grid container justify="center" spacing={0}>
				<Grid item xs={12}>
					<AppBar position="static">
						<Toolbar>
						</Toolbar></AppBar>
				</Grid>
				<Grid item className={classes.margin} xs={12} md={10} lg={8}>
					<Paper className={classes.paper}>
						<Grid container spacing={2}>
							<Grid item xs={12}>
								<Typography variant="h5" component="h3">
									Générateur de questionnaires
								</Typography>

								<Divider />
							</Grid>

							<Grid item xs={12} md={6} lg={4}>
								<TextField
									id="outlined-name"
									name="name"
									label="Nom du questionnaire"
									className={classes.textField}
									value={state.name}
									onChange={handleChange}
									margin="normal"
									variant="outlined"
									fullWidth
								/>
							</Grid>

							<Grid item xs={12}>
								<Grid container spacing={2}>
									{state.sections.map((section, i) =>
										<Grid
											item
											xs={12}
											key={"s" + i}>
											<Section
												section={section}
												deleteSection={deleteSection(i)}
												setSection={setSection(i)}
											/>
										</Grid>
									)}
								</Grid>
							</Grid>

							<Grid item xs={12}>
								<Button
									size="medium"
									variant="contained"
									color="primary"
									onClick={addSection}
								>
									Ajouter une section
								</Button>
								<Button
									size="medium"
									variant="contained"
									color="primary"
									onClick={save}
								>
									Sauvegarder la configuration
								</Button>
								<Button
									size="medium"
									variant="contained"
									color="primary"
									onClick={generate}
								>
									Générer le formulaire
								</Button>
							</Grid>
						</Grid>
					</Paper>
				</Grid>

				<Grid item className={classes.margin} xs={12} md={10} lg={8}>
					<Paper className={classes.paper}>
						<Grid container spacing={2}>
							<Grid item xs={12}>
								<Typography variant="h5" component="h3">
									Importer une configuration existante
								</Typography>

								<Divider />
							</Grid>

							<Grid item xs={12}>
								<TextField
									label="Configuration"
									fullWidth
									multiline
									margin="normal"
									variant="outlined"
									name="config"
									value={state.config}
									onChange={handleChange}
								/>
							</Grid>

							<Grid item xs={12}>
								<Button
									size="medium"
									variant="contained"
									color="primary"
									onClick={loadConfig}
								>
									Importer la configuration
								</Button>
							</Grid>
						</Grid>
					</Paper>
				</Grid>
			</Grid>
	);
}

export default App;
