import React, { useEffect } from 'react';
import { makeStyles } from '@material-ui/core/styles';

import Grid from '@material-ui/core/Grid';
import ExpansionPanel from '@material-ui/core/ExpansionPanel';
import ExpansionPanelSummary from '@material-ui/core/ExpansionPanelSummary';
import ExpansionPanelDetails from '@material-ui/core/ExpansionPanelDetails';
import Typography from '@material-ui/core/Typography';
import Button from '@material-ui/core/Button';
import TextField from "@material-ui/core/TextField";

import ExpandMoreIcon from '@material-ui/icons/ExpandMore';

import { Danger } from "./Buttons";
import Category from "./Category";

const useStyles = makeStyles(theme => ({
    root: {
        width: '100%',
    },
    heading: {
        fontSize: theme.typography.pxToRem(15),
        fontWeight: theme.typography.fontWeightRegular,
    },
}));

export default function SimpleExpansionPanel(props) {
    const classes = useStyles();
    const { setSection, section } = props;

    useEffect(() => {
    }, [])

    const handleChange = e => {
        setSection({ ...section, [e.target.id]: e.target.value })
    }

    const addCategory = () => {
        setSection({ ...section, categories: [...section.categories, { name: "Nouvelle catégorie", subCategories: [] }] })
    }

    const deleteCategory = i => () => {
        if (window.confirm("Êtes vous sûr de vouloir supprimer cette catégorie ?"))
            setSection({ ...section, categories: section.categories.filter((s, ind) => ind !== i) })
    }

    const setCategory = i => update => {
        let categories = Object.assign(section.categories);
        categories[i] = update;
        setSection({ ...section, categories });
    }

    return (
        <div className={classes.root}>
            <ExpansionPanel>
                <ExpansionPanelSummary
                    expandIcon={<ExpandMoreIcon />}
                    aria-controls="panel1a-content"
                    id="panel1a-header"
                >
                    <Typography className={classes.heading}>{props.section.name}</Typography>
                </ExpansionPanelSummary>
                <ExpansionPanelDetails>
                    <Grid container spacing={2}>
                        <Grid item xs={12}>
                            <TextField
                                id="name"
                                label="Nom de la section"
                                value={section.name}
                                onChange={handleChange}
                                className={classes.textField}
                                margin="normal"
                                variant="outlined"
                                fullWidth
                            />
                        </Grid>

                        <Grid item xs={12}>
                            {section.categories.map((category, i) =>
                                <Category
                                    key={"c" + i}
                                    category={category}
                                    deleteCategory={deleteCategory(i)}
                                    setCategory={setCategory(i)}
                                />)}
                        </Grid>

                        <Grid item xs={12}>
                            <Button
                                size="medium"
                                variant="contained"
                                color="primary"
                                onClick={addCategory}
                            >
                                Ajouter une catégorie
                            </Button>
                            <Danger
                                size="medium"
                                variant="contained"
                                color="primary"
                                onClick={props.deleteSection}
                            >
                                Supprimer la section
                            </Danger>
                        </Grid>
                    </Grid>
                </ExpansionPanelDetails>
            </ExpansionPanel>
        </div>
    );
}
