import React from "react";

import { makeStyles } from "@material-ui/core/styles"
import Grid from "@material-ui/core/Grid";
import Divider from "@material-ui/core/Divider";
import Typography from "@material-ui/core/Typography";
import TextField from "@material-ui/core/TextField";
import Button from "@material-ui/core/Button";

import { Danger } from "./Buttons";
import SubCategory from "./SubCategory";

const useStyles = makeStyles(theme => ({
    heading: {
        fontSize: theme.typography.pxToRem(15),
        fontWeight: theme.typography.fontWeightRegular,
    },
}));

export default function Category(props) {
    const classes = useStyles();
    const { category, setCategory } = props;

    const handleChange = e => {
        setCategory({ ...category, [e.target.id]: e.target.value })
    }

    const addSubCategory = () => {
        setCategory({
            ...category, subCategories: [...category.subCategories,
            {
                name: "Nouvelle sous catégorie",
                coeff: 1,
                required: true,
                type: "",
                upper: "Excellent",
                lower: "Nul"
            }
            ]
        })
    }

    const deleteSubCategory = i => () => {
        if (window.confirm("Êtes vous sûr de vouloir supprimer cette sous catégorie ?"))
            setCategory({ ...category, subCategories: category.subCategories.filter((s, ind) => ind !== i) })
    }

    const setSubCategory = i => update => {
        let subCategories = Object.assign(category.subCategories);
        subCategories[i] = update;
        setCategory({ ...category, subCategories });
    }

    return (
        <Grid container spacing={2} justify="flex-end">
            <Grid item xs={12} md={10}>
                <Divider />
                <Typography variant="h6" component="h5">
                    {category.name}
                </Typography>
            </Grid>
            <Grid item xs={12} md={10}>
                <TextField
                    id="name"
                    label="Nom de la categorie"
                    value={category.name}
                    onChange={handleChange}
                    className={classes.textField}
                    margin="normal"
                    variant="outlined"
                    fullWidth
                />
            </Grid>

            <Grid item xs={12} md={10}>
                {category.subCategories.map((sc, i) =>
                    <SubCategory
                        key={"sc" + i}
                        subCategory={sc}
                        setSubCategory={setSubCategory(i)}
                        deleteSubCategory={deleteSubCategory(i)}
                    />)
                }
            </Grid>

            <Grid item xs={12} md={10}>
                <Button
                    size="small"
                    variant="contained"
                    color="primary"
                    onClick={addSubCategory}
                >
                    Ajouter une sous catégorie
                            </Button>
                <Danger
                    size="small"
                    variant="contained"
                    color="primary"
                    onClick={props.deleteCategory}
                >
                    Supprimer la catégorie
                            </Danger>
            </Grid>
        </Grid>
    )
}