import React from "react";

import { makeStyles } from "@material-ui/core/styles";
import Grid from "@material-ui/core/Grid";
import ExpansionPanel from '@material-ui/core/ExpansionPanel';
import ExpansionPanelSummary from '@material-ui/core/ExpansionPanelSummary';
import ExpansionPanelDetails from '@material-ui/core/ExpansionPanelDetails';
import FormControlLabel from "@material-ui/core/FormControlLabel";
import Checkbox from "@material-ui/core/Checkbox";
import Typography from "@material-ui/core/Typography";
import TextField from "@material-ui/core/TextField";

import ExpandMoreIcon from '@material-ui/icons/ExpandMore';

import { Danger } from "./Buttons";

const useStyles = makeStyles(theme => ({
    heading: {
        fontSize: theme.typography.pxToRem(15),
        fontWeight: theme.typography.fontWeightRegular,
    },
    root: {
        marginBottom: theme.spacing(3)
    }
}));

export default function SubCategory(props) {
    const classes = useStyles();
    const { setSubCategory, subCategory } = props;

    const handleChange = e => {
        if (e.target.type === "text")
            setSubCategory({ ...subCategory, [e.target.id]: e.target.value })
        else if (e.target.type === "number" && parseInt(e.target.value) >= 1)
            setSubCategory({ ...subCategory, [e.target.id]: parseInt(e.target.value) })
        else if (e.target.type === "checkbox")
            if (e.target.id === "type")
                setSubCategory({ ...subCategory, type: (e.target.checked ? "text" : "") })
            else
                setSubCategory({ ...subCategory, [e.target.id]: e.target.checked })
    }

    return (
        <Grid container spacing={2} justify="flex-end">
            <Grid item xs={12} md={10}>
                <ExpansionPanel>
                    <ExpansionPanelSummary
                        expandIcon={<ExpandMoreIcon />}
                        aria-controls="panel1a-content"
                        id="panel1a-header"
                    >
                        <Typography className={classes.heading}>{subCategory.name}</Typography>
                    </ExpansionPanelSummary>
                    <ExpansionPanelDetails>
                        <Grid container justify="flex-end" alignItems="center" className={classes.root} spacing={2}>
                            <Grid item xs={12} md={10}>
                                <TextField
                                    id="name"
                                    label="Nom de la categorie"
                                    value={subCategory.name}
                                    onChange={handleChange}
                                    className={classes.textField}
                                    margin="normal"
                                    variant="outlined"
                                    fullWidth
                                />
                            </Grid>
                            {subCategory.type === "" &&
                                <Grid item xs={12} md={4}>
                                    <TextField
                                        id="coeff"
                                        label="Coefficient"
                                        value={subCategory.coeff}
                                        onChange={handleChange}
                                        type="number"
                                        InputLabelProps={{
                                            shrink: true,
                                        }}
                                        margin="normal"
                                        variant="outlined"
                                    />
                                </Grid>
                            }
                            <Grid item xs={12} md={3}>
                                <FormControlLabel
                                    value="top"
                                    control={
                                        <Checkbox
                                            color="primary"
                                            id="type"
                                            onChange={handleChange}
                                            checked={subCategory.type === "text"} />
                                    }
                                    label="Texte"
                                    labelPlacement="top"
                                />
                            </Grid>

                            <Grid item xs={12} md={3}>
                                <FormControlLabel
                                    value="top"
                                    control={
                                        <Checkbox
                                            color="primary"
                                            id="required"
                                            onChange={handleChange}
                                            checked={subCategory.required}
                                        />
                                    }
                                    label="Requis"
                                    labelPlacement="top"
                                />
                            </Grid>
                            {subCategory.type === "" &&
                                <>
                                    <Grid item xs={12} md={5}>
                                        <TextField
                                            id="upper"
                                            label="Label valeur haute"
                                            value={subCategory.upper}
                                            onChange={handleChange}
                                            className={classes.textField}
                                            margin="normal"
                                            variant="outlined"
                                            fullWidth
                                        />
                                    </Grid>
                                    <Grid item xs={12} md={5}>
                                        <TextField
                                            id="lower"
                                            label="Label valeur basse"
                                            value={subCategory.lower}
                                            onChange={handleChange}
                                            className={classes.textField}
                                            margin="normal"
                                            variant="outlined"
                                            fullWidth
                                        />
                                    </Grid>
                                </>
                            }
                            <Grid item xs={12} md={10}>
                                <Danger
                                    size="small"
                                    variant="contained"
                                    color="primary"
                                    onClick={props.deleteSubCategory}
                                >
                                    Supprimer la sous catégorie
                            </Danger>
                            </Grid>
                        </Grid >
                    </ExpansionPanelDetails>
                </ExpansionPanel>
            </Grid>
        </Grid>
    );
}