import React, { useEffect, useState } from 'react';
import { makeStyles } from '@material-ui/core/styles';

import Grid from '@material-ui/core/Grid';
import ExpansionPanel from '@material-ui/core/ExpansionPanel';
import ExpansionPanelSummary from '@material-ui/core/ExpansionPanelSummary';
import ExpansionPanelDetails from '@material-ui/core/ExpansionPanelDetails';
import Typography from '@material-ui/core/Typography';
import Button from '@material-ui/core/Button';
import TextField from "@material-ui/core/TextField";

import ExpandMoreIcon from '@material-ui/icons/ExpandMore';

import { Danger } from "./Buttons";

const useStyles = makeStyles(theme => ({
    root: {
        width: '100%',
    },
    heading: {
        fontSize: theme.typography.pxToRem(15),
        fontWeight: theme.typography.fontWeightRegular,
    },
}));

function Section(props) {
    const classes = useStyles();
    const {
        section,
        setElement,
        deleteElement
    } = props;

    const [categoriesCreated, setCategoriesCreated] = useState(0);

    useEffect(() => {
    }, [])

    const handleChange = e =>
        setElement({
            id: section.id,
            update: {
                ...section,
                [e.target.id]: e.target.value
            }
        });


    const addCategory = () => {
        setElement({
            id: section.id,
            update: {
                ...section,
                totalCoeff: section.totalCoeff + 1,
                categories: [
                    ...section.categories,
                    {
                        id: section.id + "," + categoriesCreated,
                        name: "Nouvelle catégorie",
                        coeff: 1,
                        subCategories: [],
                        totalCoeff: 0,
                    }
                ]
            }
        });
        setCategoriesCreated(categoriesCreated + 1);
    }

    const deleteSection = () => {
        if (window.confirm("Êtes vous sûr de vouloir supprimer cette section ?"))
            deleteElement(section.id);
    }

    return (
        <div className={classes.root}>
            <ExpansionPanel>
                <ExpansionPanelSummary
                    expandIcon={<ExpandMoreIcon />}
                    aria-controls="panel1a-content"
                    id="panel1a-header"
                >
                    <Typography className={classes.heading}>{props.section.name}</Typography>
                </ExpansionPanelSummary>
                <ExpansionPanelDetails>
                    <Grid container spacing={2}>
                        <Grid item xs={12}>
                            <TextField
                                id="name"
                                label="Nom de la section"
                                value={section.name}
                                onChange={handleChange}
                                className={classes.textField}
                                margin="normal"
                                variant="outlined"
                                fullWidth
                            />
                        </Grid>

                        <Grid item xs={12}>
                            {props.children}
                        </Grid>

                        <Grid item xs={12}>
                            <Button
                                size="medium"
                                variant="contained"
                                color="primary"
                                onClick={addCategory}
                            >
                                Ajouter une catégorie
                            </Button>
                            <Danger
                                size="medium"
                                variant="contained"
                                color="primary"
                                onClick={deleteSection}
                            >
                                Supprimer la section
                            </Danger>
                        </Grid>
                    </Grid>
                </ExpansionPanelDetails>
            </ExpansionPanel>
        </div>
    );
}

const shouldUpdate = (prevProp, nextProp) => nextProp.toUpdate === nextProp.section.id;

export default React.memo(Section, shouldUpdate)
