import React, { useState, useEffect } from 'react';
import { saveAs } from "file-saver";
import './App.css';

import { makeStyles } from '@material-ui/core/styles';
import Paper from "@material-ui/core/Paper";
import TextField from "@material-ui/core/TextField";
import Divider from "@material-ui/core/Divider";
import Grid from "@material-ui/core/Grid";
import AppBar from "@material-ui/core/AppBar";
import Toolbar from '@material-ui/core/Toolbar';
import Typography from '@material-ui/core/Typography';
import Button from "@material-ui/core/Button";
import CircularProgress from "@material-ui/core/CircularProgress";
import Section from "./Section";

const useStyles = makeStyles(theme => ({
	root: {
		flexGrow: 1
	},
	paper: {
		padding: theme.spacing(2, 3)
	},
	menuButton: {
		marginRight: theme.spacing(2),
	},
	title: {
		flexGrow: 1,
	},
	margin: {
		marginTop: theme.spacing(3),
	},
	button: {
		margin: theme.spacing(1),
	},
	rightBot: {
		bottom: "10px",
		right: "15px",
		position: "fixed"
	}
}));

function App() {
	const classes = useStyles();

	const [state, setState] = useState({
		sections: [],
		name: ""
	}
	);

	const [url, setURL] = useState({ url: "", requesting: false });

	useEffect(() => {
		setURL({ ...url, url: localStorage.getItem("url") || "" })
		 // eslint-disable-next-line
	}, [])

	const save = () => {
		let name = prompt("Nom du fichier");
		let blob = new Blob([JSON.stringify(state)], { type: "application/json" });
		saveAs(blob, name + ".json");
	}

	const generate = () => {
		const data = { name: state.name, sections: state.sections };
		setURL({ ...url, requesting: true });

		fetch(url.url, {
			method: "POST",
			body: JSON.stringify(data)
		})
			.then(res => {
				setURL({ ...url, requesting: false });
				alert("Questionnaire crée")
			})
			.catch(err => {
				setURL({ ...url, requesting: false });
				alert(err.message)
				console.error(err);
			});
	}

	const loadConfig = () => {
		let config;
		try {
			config = JSON.parse(state.config)
		} catch (e) {
			alert("Impossible de charger cette configuration")
			return;
		}
		setState({ ...state, ...config })
	}

	const saveURL = () => {
		localStorage.setItem("url", url.url);
	}

	const addSection = () => {
		setState({ ...state, sections: [...state.sections, { name: "Nouvelle section", categories: [] }] });
	}

	const deleteSection = i => () => {
		if (window.confirm("Êtes vous sûr de vouloir supprimer cette section ?"))
			setState({ sections: state.sections.filter((s, ind) => ind !== i) })
	}

	const setSection = i => update => {
		let sections = Object.assign(state.sections);
		sections[i] = update;
		setState({
			...state,
			sections: sections
		});
	}

	const handleChange = e => {
		if (e.target.name !== "url")
			setState({ ...state, [e.target.name]: e.target.value });
		else
			setURL({ url: e.target.value });
	}

	return (
		<Grid container justify="center" spacing={0}>
			<Grid item xs={12}>
				<AppBar position="static">
					<Toolbar>
                    <Button color="inherit" style={{marginLeft: 'auto'}}>
                        Créé par Théophile BORNON pour<br />le Pole Universitaire Léonard de Vinci
                    </Button>
					</Toolbar>
				</AppBar>
			</Grid>
			<Grid item className={classes.margin} xs={12} md={10} lg={8}>
				<Paper className={classes.paper}>
					<Grid container spacing={2}>
						<Grid item xs={12}>
							<Typography variant="h5" component="h3">
								Générateur de questionnaires
								</Typography>

							<Divider />
						</Grid>

						<Grid item xs={12} md={6} lg={4}>
							<TextField
								id="outlined-name"
								name="name"
								label="Nom du questionnaire"
								className={classes.textField}
								value={state.name}
								onChange={handleChange}
								margin="normal"
								variant="outlined"
								fullWidth
							/>
						</Grid>

						<Grid item xs={12}>
							<Grid container spacing={2}>
								{state.sections.map((section, i) =>
									<Grid
										item
										xs={12}
										key={"s" + i}>
										<Section
											section={section}
											deleteSection={deleteSection(i)}
											setSection={setSection(i)}
										/>
									</Grid>
								)}
							</Grid>
						</Grid>

						<Grid item xs={12}>
							<Button
								size="medium"
								variant="contained"
								color="primary"
								onClick={addSection}
							>
								Ajouter une section
								</Button>
							<Button
								size="medium"
								variant="contained"
								color="primary"
								onClick={save}
							>
								Sauvegarder la configuration
								</Button>
							<Button
								size="medium"
								variant="contained"
								color="primary"
								onClick={generate}
							>
								Générer le formulaire
								</Button>
							{url.requesting &&
								<CircularProgress />
							}
						</Grid>
					</Grid>
				</Paper>
			</Grid>

			<Grid item className={classes.margin} xs={12} md={10} lg={8}>
				<Paper className={classes.paper}>
					<Grid container spacing={2}>
						<Grid item xs={12}>
							<Typography variant="h5" component="h3">
								Importer une configuration existante
				</Typography>

							<Divider />
						</Grid>

						<Grid item xs={12}>
							<TextField
								label="Configuration"
								fullWidth
								multiline
								margin="normal"
								variant="outlined"
								name="config"
								value={state.config}
								onChange={handleChange}
							/>
						</Grid>

						<Grid item xs={12}>
							<Button
								size="medium"
								variant="contained"
								color="primary"
								onClick={loadConfig}
							>
								Importer la configuration
				</Button>
						</Grid>
					</Grid>
				</Paper>
			</Grid>

			<Grid item className={classes.margin} xs={12} md={10} lg={8}>
				<Paper className={classes.paper}>
					<Grid container spacing={2}>
						<Grid item xs={12}>
							<Typography variant="h5" component="h3">
								URL de l'application
							</Typography>

							<Divider />
						</Grid>

						<Grid item xs={12}>
							<TextField
								label="URL"
								fullWidth
								multiline
								margin="normal"
								variant="outlined"
								name="url"
								value={url.url}
								onChange={handleChange}
							/>
						</Grid>

						<Grid item xs={12}>
							<Button
								size="medium"
								variant="contained"
								color="primary"
								onClick={saveURL}
							>
								Sauvegarder l'URL
				</Button>
						</Grid>
					</Grid>
				</Paper>
			</Grid>
		</Grid>
	);
}

export default App;
