var DIRECTORY = "1mSXxKP1lDxNwTIUSJK2EDiTJMA2dRphJ";

function create(data) {
    main(data);
}

function main(data) {
    // Creating form
    var form = FormApp.create(data.name);
    var formFile = DriveApp.getFileById(form.getId());

    // Creating spreadsheet for answers
    var ss = SpreadsheetApp.create(data.name);
    var ssFile = DriveApp.getFileById(ss.getId());

    // Creating spreadsheet which is going to be published
    var publishedSS = SpreadsheetApp.create("Resulats");
    var publishedSSFile = DriveApp.getFileById(publishedSS.getId());

    // Add published spreadsheet id to answer spreadsheet metadata
    ss.addDeveloperMetadata("resultsID", publishedSS.getId());
    ssFile.setDescription(publishedSS.getId());

    buildForm(data, form);
    form.setDestination(FormApp.DestinationType.SPREADSHEET, ss.getId());
    ScriptApp.newTrigger('onDeposit')
        .forForm(form)
        .onFormSubmit()
        .create();

    // Set first row for published results
    var sheet = publishedSS.getSheets()[0];
    buildResults(data, sheet);

    // Save data structure
    var dataF = DriveApp.createFile("data.json", JSON.stringify(data), 'application/json');
    var dataFile = DriveApp.getFileById(dataF.getId());


    // Add data file id to answer spreadsheet metadata
    ss.addDeveloperMetadata("dataID", dataFile.getId());

    var fileIds = { "data": dataFile.getId(), "results": publishedSS.getId() };
    ssFile.setDescription(JSON.stringify(fileIds));

    // Create folder
    var folder = DriveApp.createFolder(data.name);
    var mainFolder = DriveApp.getFolderById(DIRECTORY);
    mainFolder.addFolder(folder);
    folder.addFile(formFile);
    folder.addFile(ssFile);
    folder.addFile(publishedSSFile);
    folder.addFile(dataFile);

    Logger.log("Published file id : %s\nData file id : %s", publishedSSFile.getId(), dataFile.getId());

    // Move files to folder
    folder.getParents().next().removeFolder(folder);
    formFile.getParents().next().removeFile(formFile);
    ssFile.getParents().next().removeFile(ssFile);
    publishedSSFile.getParents().next().removeFile(publishedSSFile);
    dataFile.getParents().next().removeFile(dataFile);

}

function buildResults(data, publishedSS) {
    var header = [];
    var itemNumber = [];
    for (var i = 0; i < data.sections.length; i++) {
        itemNumber[i] = 0;
        for (var j = 0; j < data.sections[i].categories.length; j++) {
            if (i !== 1) {
                for (var k = 0; k < data.sections[i].categories[j].subCategories.length; k++) {
                    itemNumber[i]++;
                    header.push(data.sections[i].categories[j].subCategories[k].name);
                }
            } else {
                header.push(data.sections[i].categories[j].name);
                itemNumber[i]++;
            }
        }
    }

    header.push("Total");
    publishedSS.appendRow(header);
    publishedSS.setFrozenRows(1);

    publishedSS
        .getRange(1, 1, 1, itemNumber[0])
        .setBackground("#D3D3D3");

    publishedSS
        .getRange(1, itemNumber[0] + 1, 1, itemNumber[1])
        .setBackground("#90EE90");

    publishedSS
        .getRange(1, itemNumber[0] + itemNumber[1] + 1, 1, 1)
        .setBackground("#FFDAB9")

    publishedSS
        .getRange(2, 1, 200, header.length)
        .setBorder(true, true, true, true, true, true, "black", SpreadsheetApp.BorderStyle.SOLID);

    publishedSS
        .getRange(1, 1, 1, header.length)
        .setBorder(true, true, true, true, true, true, "black", SpreadsheetApp.BorderStyle.SOLID_THICK)
        .setFontWeight("bold");
}

function buildForm(data, form) {
    for (var h = 0; h < data.sections.length; h++) {
        var section = data.sections[h];

        form
            .addPageBreakItem()
            .setTitle(section.name || "");

        for (var i = 0; i < section.categories.length; i++) {
            var category = section.categories[i];

            form.addSectionHeaderItem()
                .setTitle(category.name || "")
                .setHelpText(category.description || "");

            for (var j = 0; j < category.subCategories.length; j++) {
                var subCategory = category.subCategories[j];

                if (subCategory.type === "text") {
                    form
                        .addTextItem()
                        .setTitle(subCategory.name || "")
                        .setHelpText(subCategory.description || "")
                        .setRequired(subCategory.required != undefined ? subCategory.required : true);
                } else {
                    form
                        .addScaleItem()
                        .setTitle(subCategory.name)
                        .setBounds(0, 10)
                        .setLabels(
                            subCategory.lower || "Nul",
                            subCategory.upper || "Excellent"
                        )
                        .setHelpText(subCategory.description || "")
                        .setRequired(subCategory.required != undefined ? subCategory.required : true);
                }
            }
        }
    }
}

function setMarks(data, itemResponses) {
    var categories = data.sections[1].categories;

    // On parcourt les réponses du questionnaire
    for (var h = 0; h < itemResponses.length; h++) {
        var itemResponse = itemResponses[h];
        var title = itemResponse.getItem().getTitle();

        // On parcourt les catégories existantes
        for (var i = 0; i < categories.length; i++) {
            var category = categories[i];
            // On parcourt les sous catégories
            for (var j = 0; j < category.subCategories.length; j++) {
                var subCategory = category.subCategories[j];
                // Si le nom de la sous catégorie correspond à celui de la réponse
                if (subCategory.name === title) {
                    // Alors on met la note
                    subCategory.mark = itemResponse.getResponse();
                }
            }
        }
    }

    return categories;
}

function calculateAverage(categories) {
    var sectionTotal = 0;
    var sectionCoeff = 0;

    for (var i = 0; i < categories.length; i++) {
        var category = categories[i];
        var categoryTotal = 0;
        var categoryCoeff = 0;

        for (var j = 0; j < category.subCategories.length; j++) {
            var subCategory = categories[i].subCategories[j];

            categoryTotal += (subCategory.mark || 0) * (subCategory.coeff || 1);
            categoryCoeff += (subCategory.coeff || 1);
        }

        category.avg = categoryTotal / categoryCoeff;

        sectionTotal += category.avg * (category.coeff || 1);
        sectionCoeff += (category.coeff || 1);
    }

    var avg = sectionTotal / sectionCoeff;

    return { avg: avg, categories: categories };
}

// Fonction appelée lorsque l'on clique sur générer sur le forumlaire
function doPost(e) {
    var data = JSON.parse(e.postData.contents);
    create(data);
    return ContentService.createTextOutput("Ok");
}

function onDeposit(e) {
    var form = FormApp.openById(e.source.getId());
    var ss = SpreadsheetApp.openById(form.getDestinationId());
    var ssFile = DriveApp.getFileById(form.getDestinationId());

    var fileIds = JSON.parse(ssFile.getDescription());

    var published = SpreadsheetApp.openById(fileIds.results);
    var publishedSheet = published.getSheets()[0];

    var dataString = DriveApp.getFileById(fileIds.data).getBlob().getDataAsString();
    var data = JSON.parse(dataString);

    var itemResponses = e.response.getItemResponses();

    var categories = setMarks(data, itemResponses);
    var results = calculateAverage(categories);

    var newRow = [];

    for (var i = 0; i < data.sections.length; i++) {
        for (var j = 0; j < data.sections[i].categories.length; j++) {
            if (i !== 1) {
                for (var k = 0; k < data.sections[i].categories[j].subCategories.length; k++) {
                    newRow.push(itemResponses[newRow.length].getResponse());
                }
            } else {
                newRow.push(results.categories[j].avg);
            }
        }
        if (i == 1)
            newRow.push(results.avg)
    }

    publishedSheet.appendRow(newRow);
}